<?php

namespace Bongo\Framework\Http\ViewComposers;

use Illuminate\Support\Str;
use Illuminate\View\View;

/**
 * Class PackageComposer.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Http\ViewComposers
 */
class PackageComposer
{
    /**
     * Bind data to the view.
     *
     * @param View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        $packages = [];
        $viewData = $view->getData();

        // If developer add components
        if (user()->isDeveloper()) {
            $packages['components'] = [
                'name'   => 'Components',
                'url'    => route('backend.component.index'),
                'icon'   => 'component',
                'route'  => 'backend.component',
                'active' => route_is('backend.component'),
            ];
            $packages['designs'] = [
                'name'   => 'Sections',
                'url'    => route('backend.design.index'),
                'icon'   => 'design',
                'route'  => 'backend.design',
                'active' => route_is('backend.design'),
            ];
            $packages['forms'] = [
                'name'   => 'Forms',
                'url'    => route('backend.form.index'),
                'icon'   => 'form',
                'route'  => 'backend.form',
                'active' => route_is('backend.form'),
            ];
            $packages['images'] = [
                'name'   => 'Images',
                'url'    => route('backend.image.index'),
                'icon'   => 'image',
                'route'  => 'backend.image',
                'active' => route_is('backend.image'),
            ];
        }

        // Add the database packages
        foreach (package()->allActive() as $package) {
            $packages[strtolower($package->name)] = [
                'name'   => Str::plural($package->name),
                'url'    => $package->getUrl(),
                'icon'   => $package->icon,
                'route'  => $package->route,
                'active' => route_is($package->route),
            ];
        }

        // If manager add users
        if (user()->isManager() || user()->isDeveloper()) {
            $packages['users'] = [
                'name'   => 'Users',
                'url'    => route('backend.user.index'),
                'icon'   => 'user',
                'route'  => 'backend.user',
                'active' => route_is('backend.user'),
            ];
        }

        // If developer add redirects
        if (user()->isDeveloper()) {
            $packages['redirects'] = [
                'name'   => 'Redirects',
                'url'    => route('backend.redirect.index'),
                'icon'   => 'redirect',
                'route'  => 'backend.redirect',
                'active' => route_is('backend.redirect'),
            ];
            $packages['settings'] = [
                'name'   => 'Settings',
                'url'    => route('backend.setting.index'),
                'icon'   => 'setting',
                'route'  => 'backend.setting',
                'active' => route_is('backend.setting'),
            ];
        }

        // Sort by name
        ksort($packages);

        // Add the default dashboard item
        if (isset($viewData['show_dashboard'])) {
            array_unshift($packages, [
                'name'   => 'Dashboard',
                'url'    => url()->to(config('settings.backend_prefix')),
                'icon'   => 'dashboard',
                'route'  => 'backend',
                'active' => route_is('backend'),
            ]);
        }

        // Pass the data to the view partial
        $view->with(compact('packages'));
    }
}
