<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Str;

/**
 * Trait HasKey.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasKey
{
    /**
     * Init the trait.
     */
    public function initializeHasKey()
    {
        $this->mergeFillable(['key']);
    }

    /**
     * Register booting.
     */
    public static function bootHasKey()
    {
        static::saving(function ($model) {
            if (empty($model->key)) {
                $model->key = $model->formatKey($model->name);
            }

            return $model;
        });
    }

    /**
     * @param $input
     *
     * @return string
     */
    public function formatKey($input)
    {
        $input = str_replace('/', '_', $input);
        $input = Str::slug($input, '_');
        $input = trim($input);
        $input = strtolower($input);

        return $input;
    }
}
