<?php

namespace Bongo\Framework\Traits;

/**
 * Trait HasStatusTrait.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasStatus
{
    /**
     * Init the trait.
     */
    public function initializeHasStatus()
    {
        $this->mergeFillable(['status']);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopePending($query)
    {
        return $query->where('status', self::PENDING);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeActive($query)
    {
        return $query->where('status', self::ACTIVE);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeInactive($query)
    {
        return $query->where('status', self::INACTIVE);
    }

    /**
     * @return bool
     */
    public function isPending()
    {
        return $this->status === self::PENDING;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->status === self::ACTIVE;
    }

    /**
     * @return bool
     */
    public function isInactive()
    {
        return $this->status === self::INACTIVE;
    }
}
