@if (isset($packages) & count($packages) > 0)
    <nav class="flex-1 px-2 py-4">
        @foreach($packages as $key => $package)

            <a href="{{ $package['url'] }}"
               class="group flex items-center px-2 py-2 text-sm leading-5 font-medium rounded-sm transition ease-in-out duration-150 focus:outline-none {{ $package['active'] ? 'text-gray-900 bg-gray-100 focus:bg-gray-200' : 'text-gray-600 hover:text-gray-900 hover:bg-gray-50 focus:text-gray-900 focus:bg-gray-100' }} {{ $loop->first ? '' : 'mt-1' }}"
            >
                @if (isset($package['icon']) && view()->exists('blade::icons.' . $package['icon']))
                    <span class="sidebar__icon mr-3 h-6 w-6 transition ease-in-out duration-150 {{ $package['active'] ? 'text-gray-500' : 'text-gray-400 group-hover:text-gray-500 group-focus:text-gray-500' }}">
                        @include('blade::icons.' . $package['icon'])
                    </span>
                @endif
                <span class="sidebar__text">
                    {{ $package['name'] }}
                </span>
            </a>

        @endforeach
    </nav>
@endif
