<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Carbon\Carbon;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Support\Str;

class Date implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): ?Carbon
    {
        return ! empty($value)
            ? Carbon::parse($value)
            : null;
    }

    public function set($model, string $key, $value, array $attributes): ?string
    {
        if (empty($value)) {
            return null;
        }

        if (Str::contains($value, '/')) {
            return Carbon::createFromFormat('d/m/Y', $value)
                ->timezone(config('app.timezone'))
                ->startOfDay()
                ->format('Y-m-d');
        }

        return Carbon::parse($value)
            ->timezone(config('app.timezone'))
            ->startOfDay()
            ->format('Y-m-d');
    }
}
