<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSessionsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('sessions')) {
            Schema::create('sessions', function (Blueprint $table) {
                $table->string('id')->unique();

                $table->foreignId('user_id')->nullable();

                $table->string('ip_address')->nullable();
                $table->longText('user_agent')->nullable();
                $table->longText('payload');

                $table->integer('last_activity');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('sessions');
    }
}
