<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesGeoCoordinates
{
    /** @throws BindingResolutionException */
    public function addGeoCoordinates(): self
    {
        $this->geoCoordinates($this->geoCoordinatesId)
            ->identifier($this->geoCoordinatesId)
            ->latitude($this->getGeoLatitude())
            ->longitude($this->getGeoLongitude());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getGeoLatitude(): ?string
    {
        return setting('client::office.latitude') ?? '0.0000';
    }

    /** @throws BindingResolutionException */
    protected function getGeoLongitude(): ?string
    {
        return setting('client::office.longitude') ?? '0.0000';
    }
}
