<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

trait HasUpdatedAt
{
    public function initializeHasUpdatedAt(): void
    {
        $this->mergeFillable(['updated_at']);
    }

    public function getUpdatedAt(string $format = 'jS M Y'): string
    {
        return ! empty($this->updated_at)
            ? $this->updated_at->format($format)
            : '-- --';
    }
}
