<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\PlainLowerText;

trait HasEmail
{
    public function initializeHasEmail(): void
    {
        $this->mergeFillable(['email']);
        $this->mergeCasts(['email' => PlainLowerText::class]);
    }

    public function hasEmail(): bool
    {
        return ! empty($this->email);
    }
}
