<?php

namespace Bongo\Framework\Traits;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HasHeaderClass
{
    public function initializeHasHeaderClass(): void
    {
        $this->mergeFillable(['transparent_header', 'sticky_header']);
    }

    /**
     * @throws BindingResolutionException
     */
    public function getHeaderClass(): string
    {
        $headerClass = '';

        // If transparent header is enabled in the settings and not disabled on the page
        if ($this->hasTransparentHeader()) {
            $headerClass .= ' is-transparent';
        }

        // If sticky header is enabled in the settings and not disabled on the page
        if ($this->hasStickyHeader()) {
            $headerClass .= ' is-sticky';
        }

        return ltrim($headerClass, ' ');
    }

    /**
     * @throws BindingResolutionException
     */
    public function hasTransparentHeader(): bool
    {
        if (empty($this->transparent_header) || $this->transparent_header === 'default') {
            return setting()->hasTransparentHeader();
        }

        return $this->transparent_header === 'enabled';
    }

    /**
     * @throws BindingResolutionException
     */
    public function hasStickyHeader(): bool
    {
        if (empty($this->sticky_header) || $this->sticky_header === 'default') {
            return setting()->hasStickyHeader();
        }

        return $this->sticky_header === 'enabled';
    }
}
