<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

    <head>
        @include('framework::frontend.layouts.partials.analytics')
        @include('framework::frontend.layouts.partials.pixel')

        @php
            $version   = setting('system::misc.version');
            $pageUrl   = preg_replace("/\?.*$/", '', request()->path());
            $pageTitle = request()->segment(count(request()->segments()));
            $pageTitle = ucwords(str_replace(['_', '-'], ' ', $pageTitle));
            $pageClass = request()->segment(1) ? str(request()->segment(1))->singular() . '-page' : '';

            $metaTitle = ucwords(str_replace(['/'], ' > ', $pageUrl));
            $metaTitle = ucwords(str_replace(['_', '-'], ' ', $metaTitle));
        @endphp

        @yield('meta_schema')
        <title>@yield('meta_title', $metaTitle)</title>
        @include('framework::frontend.layouts.partials.meta_standard')
        @include('framework::frontend.layouts.partials.meta_open_graph')
        @include('framework::frontend.layouts.partials.meta_twitter')
        @include('framework::frontend.layouts.partials.favicon')

        @section('header_css')
            <link href="{{ asset("/css/frontend.css?{$version}") }}" rel="stylesheet" type="text/css"/>
            <link
                href="{{ config('builder.frontend_asset_path') }}/{{ config('builder.frontend_css_file') }}?{{$version}}"
                rel="stylesheet" type="text/css"
            />
            <style type="text/css">@yield('page_css')</style>
        @show
        @section('header_javascript')
            @if(setting()->reCaptchaEnabled())
                {!! captcha()->init() !!}
            @endif
        @show
    </head>

    <body class="@yield('body_class', $pageClass)">
        @include('framework::frontend.layouts.partials.analytics_no_js')
        @include('framework::frontend.layouts.partials.pixel_no_js')

        <div id="app" v-cloak>
            @include('framework::frontend.layouts.partials.admin_header')
            @section('header')
                @includeIf('builder::frontend.layout.headers.'.setting("theme::layout.header").'.index')
            @show
            @section('heading')
                @includeIf('builder::frontend.layout.headings.'.setting("theme::layout.heading").'.index')
            @show
            @section('main')
                @include('framework::frontend.layouts.partials.main')
            @show
            @section('footer')
                @includeIf('builder::frontend.layout.footers.'.setting("theme::layout.footer").'.index')
            @show
            @section('messages')
                @include('framework::frontend.layouts.partials.message')
            @show
            @section('cookies')
                @include('framework::frontend.layouts.partials.cookie_consent')
                @include('framework::frontend.layouts.partials.cookie_manager')
                @include('framework::frontend.layouts.partials.cookie_btn')
            @show
        </div>

        {{-- Footer Javascript files --}}
        @section('footer_javascript')
            <script defer src="{{ asset("/js/frontend.js?{$version}") }}" type="text/javascript"></script>
            <script defer src="{{ config('builder.vendor_asset_path') }}/lazy.js?{{$version}}" type="text/javascript"></script>
            <script defer src="{{ config('builder.vendor_asset_path') }}/validation.js?{{$version}}" type="text/javascript"></script>
            <script defer src="{{ config('builder.frontend_asset_path') }}/{{ config('builder.frontend_js_file') }}?{{$version}}" type="text/javascript"></script>
            <script defer src="{{ asset("/js/custom.js?{$version}") }}" type="text/javascript"></script>
            <script defer type="text/javascript">@yield('page_javascript')</script>
        @show
    </body>
</html>
