<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/xhtml">

    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="x-apple-disable-message-reformatting">
        <title></title>

        <!--[if mso]>
        <style>
            table {
                border-collapse: collapse;
                border-spacing: 0;
                border: none;
                margin: 0;
            }

            div, td {
                padding: 0;
            }

            div {
                margin: 0 !important;
            }
        </style>
        <noscript>
            <xml>
                <o:OfficeDocumentSettings>
                    <o:PixelsPerInch>96</o:PixelsPerInch>
                </o:OfficeDocumentSettings>
            </xml>
        </noscript>
        <![endif]-->

        <style>
            table, td, div, h1, p {
                font-family: Arial, sans-serif;
            }

            @media screen and (max-width: 530px) {
                .col-lge {
                    max-width: 100% !important;
                }
            }

            @media screen and (min-width: 531px) {
                .col-sml {
                    max-width: 27% !important;
                }

                .col-lge {
                    max-width: 73% !important;
                }
            }
        </style>
    </head>

    <body style="margin:0; padding:0; word-spacing:normal; background-color:#eeeeee;">

        <div role="article" aria-roledescription="email" lang="en"
             style="text-size-adjust:100%; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; background-color:#eeeeee;"
        >

            <table role="presentation" style="width:100%; border:none; border-spacing:0;">
                <tr>
                    <td align="center" style="padding:0;">

                        <!--[if mso]>
                        <table role="presentation" align="center" style="width:600px;">
                            <tr>
                                <td>
                        <![endif]-->

                        <table role="presentation"
                               style="width:94%; max-width:600px; border:none; border-spacing:0; text-align:left; font-family:Arial,sans-serif; font-size:16px;line-height:22px; color:#363636;"
                        >
                            @section('header')
                                @include('framework::mail.layouts.partials.header')
                            @show

                            @yield('content')

                            @section('footer')
                                @include('framework::mail.layouts.partials.footer')
                            @show

                        </table>

                        <!--[if mso]>
                        </td>
                        </tr>
                        </table>
                        <![endif]-->

                    </td>
                </tr>
            </table>

        </div>
    </body>
</html>
