<?php

use Bongo\Framework\Helpers\Cookie;
use Bongo\Framework\Helpers\Console;
use Bongo\Framework\Helpers\Log;
use Bongo\Framework\Helpers\Password;
use Bongo\Framework\Helpers\Route;
use Bongo\Framework\Helpers\Str;
use Illuminate\Contracts\Auth\Authenticatable;

/**
 * Standard helpers
 */
if (! function_exists('user')) {
    function user(): ?Authenticatable
    {
        return Auth::user();
    }
}
if (! function_exists('route_exists')) {
    function route_exists(string $name): bool
    {
        return Route::exists($name);
    }
}
if (! function_exists('route_is')) {
    function route_is(string $name): bool
    {
        return Route::is($name);
    }
}
if (! function_exists('camel_words')) {
    function camel_words(?string $input, bool $plural = false): ?string
    {
        return Str::camelWords($input, $plural);
    }
}
if (! function_exists('console_print')) {
    function console_print(string $message, string $type = 'info'): void
    {
        Console::print($message, $type);
    }
}
if (! function_exists('log_exception')) {
    function log_exception($exception, int $code = 500): void
    {
        Log::exception($exception, $code);
    }
}
if (! function_exists('generate_password')) {
    function generate_password(int $noOfChars = 32): bool|string
    {
        return Password::generate($noOfChars);
    }
}
if (! function_exists('make_key')) {
    function make_key(string $input): string
    {
        return Str::key($input);
    }
}
if (! function_exists('make_id')) {
    function make_id(string $input, $append = ''): string
    {
        return Str::id($input, $append);
    }
}

/**
 * DT Override: for builder functionality
 */
if (! function_exists('cookie_enabled')) {
    function cookie_enabled($name): bool
    {
        return Cookie::enabled($name);
    }
}
if (! function_exists('plain_text')) {
    function plain_text($input): string
    {
        $input = preg_replace('<\/h[1-6]>', '<br/>', $input);
        $input = html_entity_decode($input);
        $input = urldecode($input);

        return strip_tags($input, '<p><br>');
    }
}
if (! function_exists('encode_uri_component')) {
    function encode_uri_component($str): string
    {
        $revert = ['%21' => '!', '%2A' => '*', '%27' => "'", '%28' => '(', '%29' => ')'];

        return strtr(rawurlencode($str), $revert);
    }
}
