<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Bongo\Framework\Helpers\Str;
use Bongo\Framework\Helpers\URL;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;

class Domain implements CastsAttributes
{
    public function get(Model $model, string $key, mixed $value, array $attributes): ?string
    {
        if (! empty($value)) {
            $value = Str::plainLowerText($value);
            $value = str_replace(' ', '-', $value);
            $value = URL::withoutWWW($value);
            $value = URL::asHttps($value);

            return rtrim($value, '/');
        }

        return $value;
    }

    public function set(Model $model, string $key, mixed $value, array $attributes): ?string
    {
        if (! empty($value)) {
            $value = Str::plainLowerText($value);
            $value = str_replace(' ', '-', $value);
            $value = URL::withoutWWW($value);
            $value = URL::asHttps($value);

            return rtrim($value, '/');
        }

        return $value;
    }
}
