<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class Pence implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): float|int|null
    {
        return ! empty($value) ? $value / 100 : null;
    }

    public function set($model, string $key, $value, array $attributes): float|int
    {
        return floatval($value) * 100;
    }
}
