<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

class Time implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): ?string
    {
        return ! empty($value) ? Carbon::parse($value)->format('H:i') : null;
    }

    public function set($model, string $key, $value, array $attributes): mixed
    {
        if (! empty($value) && Str::contains($value, ':')) {
            return Carbon::createFromFormat('H:i', $value);
        }

        return $value;
    }
}
