<?php

declare(strict_types=1);

namespace Bongo\Framework\Enums;

use Illuminate\Support\Collection;

trait WithArray
{
    public static function toArray(): array
    {
        return Collection::make(self::cases())
            ->pluck('name', 'value')
            ->transform(fn ($value, $key) => self::format($value))
            ->toArray();
    }

    public static function getKeys(): array
    {
        return array_column(self::cases(), 'name');
    }

    public static function getValues(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function format(string $name): string
    {
        return ucwords(strtolower(str_replace('_', ' ', $name)));
    }

    public static function asMultiSelect(): array
    {
        return collect(self::toArray())
            ->transform(function ($value, $key) {
                return [
                    'id' => $key,
                    'name' => $value,
                ];
            })
            ->toArray();
    }

    public function getName(): string
    {
        return self::format($this->name);
    }

    public function getKey(): string
    {
        return strtolower(str_replace('', '_', $this->name));
    }

    public function getValue(): string
    {
        return self::format($this->value);
    }
}
