<?php

declare(strict_types = 1);

namespace Bongo\Framework\Helpers;

use Illuminate\Support\Facades\Log as LogFacade;

class Log
{
    public static function exception($exception, int $code = 500): void
    {
        // If this is from the console echo the message
        if (app()->runningInConsole()) {
            console_print(
                'Error Message: '.$exception->getMessage()
                .' File: '.$exception->getFile()
                .' Line: '.$exception->getLine(),
                'error'
            );

            return;
        }

        LogFacade::info(json_encode([
            'type' => get_class($exception),
            'environment' => app()->environment(),
            'message' => $exception->getMessage(),
            'file' => $exception->getFile(),
            'line_number' => $exception->getLine(),
            'uri' => request()->getUri(),
            'port' => request()->getPort(),
            'client_ip' => request()->getClientIp(),
            'method' => request()->method(),
            'format' => request()->format(),
            'headers' => json_encode(request()->header()),
            'stacktrace' => json_encode(debug_backtrace()),
            'user' => json_encode((! auth()->check()) ? [] : auth()->user()->toArray()),
            'input' => json_encode(request()->all()),
            'session' => json_encode(session()->all()),
            'server' => json_encode($_SERVER),
            'code' => $code,
        ]));
    }
}
