<?php

declare(strict_types=1);

namespace Bongo\Framework\Helpers;

use Illuminate\Support\Facades\Route as RouteFacade;

class Route
{
    public static function exists(string $name): bool
    {
        $routes = RouteFacade::getRoutes();

        foreach ($routes as $route) {
            if ($route->getName() === $name) {
                return true;
            }
        }

        return false;
    }

    public static function is(string $name): bool
    {
        $route = strtolower($name);

        $defaultRoutes = [
            "{$route}.index",
            "{$route}.create",
            "{$route}.show",
            "{$route}.edit",
            "{$route}.delete",
        ];

        // Does the specific route name match
        if (RouteFacade::currentRouteName() === $route) {
            return true;
        }

        // Is it within the defaults
        if (in_array(RouteFacade::currentRouteName(), $defaultRoutes)) {
            return true;
        }

        return false;
    }
}
