<?php

namespace Bongo\Framework\Helpers;

use Illuminate\Contracts\Container\BindingResolutionException;

class ShortCode
{
    /**
     * @throws BindingResolutionException
     */
    public static function parse($content): string
    {
        // Replace the phone number
        $companyPhone = setting()->getClientPhoneNumber() ?? '#';
        $content = str_replace('[company_phone]', $companyPhone, $content);

        // Replace the company name
        $companyName = setting('client::company.name', '#');
        $content = str_replace('[company_name]', $companyName, $content);

        // Replace the email
        $companyEmail = setting('client::company.email', '#');
        $content = str_replace('[company_email]', $companyEmail, $content);

        // Replacer the contact
        $contact = setting('client::company.contact', '#');
        $content = str_replace('[company_contact]', $contact, $content);

        // Replace the address
        $registeredAddress = setting()->getRegisteredAddress() ?? '#';
        $content = str_replace('[registered_address]', $registeredAddress, $content);

        // Replace the address
        $officeAddress = setting()->getOfficeAddress() ?? '#';
        $content = str_replace('[office_address]', $officeAddress, $content);

        // Return the parsed content
        return $content;
    }
}
