<?php

namespace Bongo\Framework\Helpers;

class Tax
{
    public static function calculate($input, $rate = 20): float|int|null
    {
        return $input * ($rate / 100);
    }

    public static function including($input, $rate = 20): ?float
    {
        return $input + self::calculate($input, $rate);
    }

    public static function excluding($input, $rate = 20): ?float
    {
        return (100 / (100 + $rate)) * $input;
    }
}
