<?php

namespace Bongo\Framework\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class MinifyHtml
{
    public function handle(Request $request, Closure $next): mixed
    {
        $response = $next($request);

        $contentType = $response?->headers?->get('Content-Type');

        if (! app()->environment('testing')
            && ! empty($contentType)
            && str_contains($contentType, 'text/html')
            && config('settings.minify_html_enabled')
        ) {
            $response->setContent($this->minify($response->getContent()));
        }

        return $response;
    }

    public function minify($input): array|string|null
    {
        $input = str_replace("\r", '', $input);
        $input = str_replace("\n", '', $input);
        $input = preg_replace(['/\>\s+/s', '/\s+</s'], ['> ', ' <'], $input);

        return trim(preg_replace('/\s\s+/', ' ', $input));
    }
}
