<?php

namespace Bongo\Framework\Http\ViewComposers;

use Illuminate\Support\Str;
use Illuminate\View\View;

class PackageComposer
{
    public function compose(View $view): void
    {
        $packages = [];
        $viewData = $view->getData();

        // Add the database packages
        foreach (package()->allActive() as $package) {
            $packages[strtolower($package->name)] = [
                'name' => Str::plural($package->name),
                'url' => $package->getUrl(),
                'icon' => $package->icon,
                'route' => $package->route,
                'active' => route_is($package->route),
            ];
        }

        if (user()->isDeveloper()) {
            $packages['components'] = [
                'name' => 'Components',
                'url' => route('backend.component.index'),
                'icon' => 'component',
                'route' => 'backend.component',
                'active' => route_is('backend.component'),
            ];
            $packages['designs'] = [
                'name' => 'Sections',
                'url' => route('backend.design.index'),
                'icon' => 'design',
                'route' => 'backend.design',
                'active' => route_is('backend.design'),
            ];
            $packages['forms'] = [
                'name' => 'Forms',
                'url' => route('backend.form.index'),
                'icon' => 'form',
                'route' => 'backend.form',
                'active' => route_is('backend.form'),
            ];
            $packages['images'] = [
                'name' => 'Images',
                'url' => route('backend.image.index'),
                'icon' => 'image',
                'route' => 'backend.image',
                'active' => route_is('backend.image'),
            ];
            $packages['layouts'] = [
                'name' => 'Layouts',
                'url' => route('backend.layout.index'),
                'icon' => 'layout',
                'route' => 'backend.layout',
                'active' => route_is('backend.layout'),
            ];
            $packages['redirects'] = [
                'name' => 'Redirects',
                'url' => route('backend.redirect.index'),
                'icon' => 'redirect',
                'route' => 'backend.redirect',
                'active' => route_is('backend.redirect'),
            ];
        }

        // If manager add users
        if (user()->isManager() || user()->isDeveloper()) {
            $packages['settings'] = [
                'name' => 'Settings',
                'url' => route('backend.setting.index'),
                'icon' => 'setting',
                'route' => 'backend.setting',
                'active' => route_is('backend.setting'),
            ];
            $packages['users'] = [
                'name' => 'Users',
                'url' => route('backend.user.index'),
                'icon' => 'user',
                'route' => 'backend.user',
                'active' => route_is('backend.user'),
            ];
        }

        // Sort by name
        ksort($packages);

        // Add the default dashboard item
        if (isset($viewData['show_dashboard'])) {
            array_unshift($packages, [
                'name' => 'Dashboard',
                'url' => url()->to(config('settings.backend_prefix')),
                'icon' => 'dashboard',
                'route' => 'backend',
                'active' => route_is('backend'),
            ]);
        }

        // Pass the data to the view partial
        $view->with(compact('packages'));
    }
}
