<?php

namespace Bongo\Framework\Schema\Concerns;

use Bongo\Review\Models\Review;
use Spatie\SchemaOrg\AggregateRating;
use Spatie\SchemaOrg\Schema;

trait HandlesReviews
{
    public function hasReviews(): bool
    {
        return app()->make('package_manager')->isEnabled('review')
            && $this->numberOfReviews() > 0;
    }

    public function getReviews(): array
    {
        $reviews = [];

        foreach (Review::active()->get() as $review) {
            $reviews[] = Schema::review()
                ->author(
                    Schema::person()->name($review->name)
                )
                ->datePublished($review->created_at)
                ->reviewBody($review->content)
                ->name($review->summary)
                ->reviewRating(
                    Schema::rating()
                        ->bestRating('5')
                        ->ratingValue($review->rating)
                        ->worstRating('1')
                );
        }

        return $reviews;
    }

    public function aggregateRatingOfReviews(): AggregateRating
    {
        return Schema::aggregateRating()
            ->ratingValue($this->averageReviewRating())
            ->reviewCount($this->numberOfReviews());
    }

    public function numberOfReviews(): int
    {
        return Review::query()->active()->count();
    }

    public function averageReviewRating(): float
    {
        $averageRating = Review::query()->active()->avg('rating');

        return ceil(floatval($averageRating));
    }
}
