<?php

namespace Bongo\Framework\Schema\Concerns;

use DateTimeInterface;
use Spatie\SchemaOrg\Graph;
use Spatie\SchemaOrg\LocalBusiness;
use Spatie\SchemaOrg\ReferencedType;
use Spatie\SchemaOrg\WebPageElement;
use Spatie\SchemaOrg\WebSite;

trait HandlesWebPage
{
    public function addWebPage(): self
    {
        $this->webPage($this->webPageId)
            ->identifier($this->webPageId)
            ->url($this->getWebPageUrl())
            ->name($this->getWebPageName())
            ->headline($this->getWebPageHeadline())
            ->description($this->getWebPageDescription())
            ->mainContentOfPage($this->getWebPageMainContent())
            ->inLanguage($this->getWebPageLanguage())
            ->author($this->getWebPageAuthor())
            ->isPartOf($this->getWebPagePartOf())
            ->datePublished($this->getWebPageDateCreated())
            ->dateCreated($this->getWebPageDateCreated())
            ->dateModified($this->getWebPageDateUpdated());

        return $this;
    }

    protected function getWebPageUrl(): ?string
    {
        return $this->getUrlForEntity($this->entity);
    }

    protected function getWebPageName(): ?string
    {
        return $this->entity->meta_title ?? $this->entity->name ?? '--';
    }

    protected function getWebPageHeadline(): ?string
    {
        return $this->entity->meta_title ?? $this->entity->name ?? '--';
    }

    protected function getWebPageDescription(): ?string
    {
        return $this->entity->meta_description ?? $this->entity->summary ?? '--';
    }

    protected function getWebPageMainContent(): WebPageElement|ReferencedType|Graph
    {
        return $this->webPageElement()
            ->identifier($this->webPageElementId)
            ->cssSelector(config('schema.css_element'))
            ->referenced();
    }

    protected function getWebPageLanguage(): string
    {
        return app()->getLocale() ?? 'en-GB';
    }

    protected function getWebPageAuthor(): LocalBusiness|ReferencedType|Graph
    {
        return $this->localBusiness($this->localBusinessId)->referenced();
    }

    protected function getWebPagePartOf(): WebSite|ReferencedType|Graph
    {
        return $this->webSite($this->webSiteId)->referenced();
    }

    protected function getWebPageDateCreated(): DateTimeInterface|string|null
    {
        return $this->entity->created_at ?? '--';
    }

    protected function getWebPageDateUpdated(): DateTimeInterface|string|null
    {
        return $this->entity->updated_at ?? '--';
    }
}
