<?php

namespace Bongo\Framework\Schema;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Database\Eloquent\Model;

class MetaSchema
{
    /** @throws BindingResolutionException */
    public function graphForPage(Model $entity): string
    {
        $graph = new PageGraph();

        // Specific to page
        $graph->setReferenceIds()
            ->setEntity($entity)
            ->addWebPage();

        // Generic across schemas
        $graph->addWebSite()
            ->addLocalBusiness()
            ->addSocialLinksToLocalBusiness()
            ->addReviewsToLocalBusiness()
            ->addContactPoint()
            ->addPostalAddress();

        // Render graph to script tag
        return $graph->toScript();
    }

    /** @throws BindingResolutionException */
    public function graphForPost(Model $entity): string
    {
        $graph = new PostGraph();

        // Specific to post
        $graph->setReferenceIds()
            ->setEntity($entity)
            ->addBlogPost();

        // Generic across schemas
        $graph->addWebSite()
            ->addLocalBusiness()
            ->addSocialLinksToLocalBusiness()
            ->addReviewsToLocalBusiness()
            ->addContactPoint()
            ->addPostalAddress();

        // Render graph to script tag
        return $graph->toScript();
    }

    /** @throws BindingResolutionException */
    public function graphForProject(Model $entity): string
    {
        $graph = new ProjectGraph();

        // Specific to project
        $graph->setReferenceIds()
            ->setEntity($entity)
            ->addArticle();

        // Generic across schemas
        $graph->addWebSite()
            ->addLocalBusiness()
            ->addSocialLinksToLocalBusiness()
            ->addReviewsToLocalBusiness()
            ->addContactPoint()
            ->addPostalAddress();

        // Render graph to script tag
        return $graph->toScript();
    }
}
