<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Address;

use Bongo\Framework\Helpers\Str;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasLatitude
{
    public function initializeHasLatitude(): void
    {
        $this->mergeFillable(['latitude']);
    }

    public function hasLatitude(): bool
    {
        return ! empty($this->latitude);
    }

    protected function latitude(): Attribute
    {
        return Attribute::make(
            set: fn ($input) => $input ? Str::plainFloat($input) : null,
        );
    }
}
