<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

trait HasCreatedAt
{
    public function initializeHasCreatedAt(): void
    {
        $this->mergeFillable(['created_at']);
    }

    public function getCreatedAt(string $format = 'jS M Y'): string
    {
        return ! empty($this->created_at)
            ? $this->created_at->format($format)
            : '-- --';
    }
}
