<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

trait HasDeletedAt
{
    public function initializeHasDeletedAt(): void
    {
        $this->mergeFillable(['deleted_at']);
    }

    public function getDeletedAt(string $format = 'jS M Y'): string
    {
        return ! empty($this->deleted_at)
            ? $this->deleted_at->format($format)
            : '-- --';
    }
}
