<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

trait HasDiff
{
    public function getDiff(): array
    {
        $changed = $this->getDirty();
        $before = $this->fresh() ? array_intersect_key($this->fresh()->getAttributes(), $changed) : [];
        $after = $changed;

        return compact('before', 'after');
    }
}
