<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\PlainNumber;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasPhone
{
    public function initializeHasPhone(): void
    {
        $this->mergeFillable([
            'phone',
            'phone_prefix'
        ]);

        $this->mergeCasts([
            'phone' => PlainNumber::class,
            'phone_prefix' => 'string'
        ]);
    }

    public function hasPhone(): bool
    {
        return ! empty($this->phone);
    }

    public function hasPhonePrefix(): bool
    {
        return ! empty($this->phone_prefix);
    }

    public function phoneFull(): Attribute
    {
        return Attribute::make(get: function () {
            return $this->hasPhonePrefix() && $this->hasPhone()
                ? $this->phone_prefix.$this->phone
                : $this->phone;
        });
    }
}
