<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

trait HasDate
{
    public function initializeHasDate()
    {
        $this->mergeFillable(['date']);
    }

    public function setDateAttribute($val)
    {
        if (! empty($val) && Str::contains($val, '/')) {
            $this->attributes['date'] = Carbon::createFromFormat('d/m/Y', $val);

            return;
        }

        if (! empty($val) && Str::contains($val, '-')) {
            $this->attributes['date'] = $val;

            return;
        }

        $this->attributes['date'] = now()->format('Y-m-d H:i:s');
    }
}
