<?php

namespace Bongo\Framework\Traits;

trait HasVisible
{
    public function initializeHasVisible(): void
    {
        $this->mergeFillable(['is_visible']);
    }

    public function scopeVisible($query)
    {
        return $query->where('is_visible', self::VISIBLE);
    }

    public function isVisible(): bool
    {
        return $this->is_visible === self::VISIBLE;
    }
}
