<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

    <head>
        @php
            $version   = setting('system::misc.version');
            $metaTitle = preg_replace("/\?.*$/", '', request()->path());
            $metaTitle = ucwords(str_replace(['_', '-', '/'], ' ', $metaTitle));
            $pageClass = request()->segment(1) ? str(request()->segment(1))->singular() . '-page' : '';
        @endphp

        <title>@yield('meta_title', $metaTitle)</title>
        @include('framework::backend.layouts.partials.meta_standard')
        @include('framework::backend.layouts.partials.favicon')

        @section('header_css')
            <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
            <link rel="stylesheet" type="text/css" href="{{ asset("css/backend.css?{$version}") }}"/>
        @show
        @yield('header_javascript')
    </head>

    <body class="relative antialiased font-sans text-gray-600 @yield('body_class', $pageClass)">

        {{-- Application viewport --}}
        <div id="app" class="h-screen flex overflow-hidden bg-gray-100" v-cloak>

            <v-sidebar>
                <template slot="sidebar-header">
                    @include('framework::backend.layouts.partials.sidebar_header')
                </template>
                <template slot="sidebar-menu">
                    @include('framework::backend.layouts.partials.sidebar_menu', ['show_dashboard' => true])
                </template>
                <template slot="sidebar-footer">
                    @include('framework::backend.layouts.partials.sidebar_footer')
                </template>
            </v-sidebar>

            <v-container>
                <v-header>
                    <template slot="header-left"></template>
                    <template slot="header-right">
                        @include('framework::backend.layouts.partials.header_sitemap')
                        @include('framework::backend.layouts.partials.header_compile')
                        @include('framework::backend.layouts.partials.header_cache')
                        <v-header-menu>
                            @include('framework::backend.layouts.partials.header_menu')
                        </v-header-menu>
                    </template>
                </v-header>
                <v-main>
                    @yield('content')
                </v-main>
            </v-container>

            @include('blade::message')
        </div>

        {{-- Footer Javascript files --}}
        @section('footer_javascript')

            {{-- Configure the user object and the backend route --}}
            <script>
                window.backend_prefix = {!! json_encode(config('settings.backend_prefix')) !!}
                    window.user = {!! json_encode(user()) !!};
            </script>

            <script defer src="{{ config('builder.vendor_asset_path') }}/lazy.js?{{$version}}" type="text/javascript"
            ></script>

            {{-- Load the main javascript file --}}
            <script type="text/javascript">
                let resource = document.createElement('script');
                resource.src = '{{ asset("js/backend.js?{$version}") }}';
                let script   = document.getElementsByTagName('script')[0];
                script.parentNode.insertBefore(resource, script);
            </script>
        @show
    </body>
</html>
