<div class="flex-shrink-0 group block">
    <div class="flex items-center text-center">

        <a href="{{ route('backend.profile.index') }}"
           class="text-gray-400 hover:text-gray-500"
           title="Click here to view your profile"
           v-tooltip='"Click here to view <br />your <b>Profile</b>"'
           tabindex="-1"
        >
            <span class="sr-only">My Profile</span>
            <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
                <path
                    d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6-3a2 2 0 11-4 0 2 2 0 014 0zm-2 4a5 5 0 00-4.546 2.916A5.986 5.986 0 0010 16a5.986 5.986 0 004.546-2.084A5 5 0 0010 11z"
                    clip-rule="evenodd" fill-rule="evenodd"
                ></path>
            </svg>
        </a>

        @if (session()->has('impersonating'))
            <a href="{{ route('backend.user.stop_impersonating') }}"
               class="ml-6 text-gray-400 hover:text-gray-500"
               title="Click here to stop impersonating"
               v-tooltip='"Click here to <br />stop <b>Impersonating</b>"'
               tabindex="-1"
            >
                <span class="sr-only">Stop impersonating</span>
                <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
                    <path
                        d="M10 2a5 5 0 00-5 5v2a2 2 0 00-2 2v5a2 2 0 002 2h10a2 2 0 002-2v-5a2 2 0 00-2-2H7V7a3 3 0 015.905-.75 1 1 0 001.937-.5A5.002 5.002 0 0010 2z"
                    ></path>
                </svg>
            </a>
        @else
            <a href="{{ url('/logout') }}"
               class="ml-6 text-gray-400 hover:text-gray-500"
               title="Click here to securely sign out"
               v-tooltip='"Click here to <br />securely <b>Sign Out</b>"'
               tabindex="-1"
               onclick="e.preventDefault();$(this).closest('form').submit();"
            >
                <span class="sr-only">Sign Out</span>
                <svg class="h-6 w-6" fill="currentColor" viewBox="0 0 20 20">
                    <path
                        d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"
                        clip-rule="evenodd" fill-rule="evenodd"
                    ></path>
                </svg>
            </a>
            <form action="{{ url('/logout') }}" method="POST" style="display: none;">
                {{ csrf_field() }}
            </form>
        @endif

    </div>
</div>
