<?php

namespace Bongo\Framework\Models;

use Bongo\Framework\Traits\Audit\HasCreatedAt;
use Bongo\Framework\Traits\Audit\HasCreatedBy;
use Bongo\Framework\Traits\Audit\HasDeletedAt;
use Bongo\Framework\Traits\Audit\HasDeletedBy;
use Bongo\Framework\Traits\Audit\HasDiff;
use Bongo\Framework\Traits\Audit\HasUpdatedAt;
use Bongo\Framework\Traits\Audit\HasUpdatedBy;
use Illuminate\Database\Eloquent\Model;

abstract class AbstractModel extends Model
{
    use HasCreatedAt;
    use HasCreatedBy;
    use HasDeletedAt;
    use HasDeletedBy;
    use HasDiff;
    use HasUpdatedAt;
    use HasUpdatedBy;

    public function attributeExists(string $key): bool
    {
        return array_key_exists($key, $this->getAttributes());
    }
}
