<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;
use Spatie\SchemaOrg\GeoCoordinates;
use Spatie\SchemaOrg\Graph;
use Spatie\SchemaOrg\PostalAddress;
use Spatie\SchemaOrg\ReferencedType;

trait HandlesPlace
{
    /** @throws BindingResolutionException */
    public function addPlace(): self
    {
        $this->place($this->placeId)
            ->identifier($this->placeId)
            ->name($this->getPlaceName())
            ->address($this->getPlaceAddress())
            ->geo($this->getPlaceGeoCoordinates());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getPlaceName(): ?string
    {
        return setting('client::office.county').', '.setting('client::office.country');
    }

    protected function getPlaceAddress(): PostalAddress|ReferencedType|Graph
    {
        return $this->postalAddress($this->postalAddressId)->referenced();
    }

    protected function getPlaceGeoCoordinates(): GeoCoordinates|ReferencedType|Graph
    {
        return $this->geoCoordinates($this->geoCoordinatesId)->referenced();
    }
}
