<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesPostalAddress
{
    /** @throws BindingResolutionException */
    public function addPostalAddress(): self
    {
        $this->postalAddress($this->postalAddressId)
            ->identifier($this->postalAddressId)
            ->streetAddress($this->getAddressStreet())
            ->addressLocality($this->getAddressLocality())
            ->addressRegion($this->getAddressRegion())
            ->postalCode($this->getAddressPostalCode())
            ->addressCountry($this->getAddressCountry());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getAddressStreet(): ?string
    {
        return setting('client::office.line_1')
            .', '.setting('client::office.line_2')
            .', '.setting('client::office.line_3');
    }

    /** @throws BindingResolutionException */
    protected function getAddressLocality(): ?string
    {
        return setting('client::office.city') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getAddressRegion(): ?string
    {
        return setting('client::office.county') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getAddressPostalCode(): ?string
    {
        return setting('client::office.postcode') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getAddressCountry(): ?string
    {
        return setting('client::office.country') ?? '--';
    }
}
