<?php

namespace Bongo\Framework\Schema\Concerns;

trait HandlesReferenceIds
{
    protected string $articleId;
    protected string $authorId;
    protected string $blogPostId;
    protected string $contactPointId;
    protected string $founderId;
    protected string $geoCoordinatesId;
    protected string $localBusinessId;
    protected string $organizationId;
    protected string $placeId;
    protected string $postalAddressId;
    protected string $webPageId;
    protected string $webPageElementId;
    protected string $webSiteId;

    public function setReferenceIds(): self
    {
        $siteUrl = config('schema.site_url') ?? url()->to('/');

        $this->articleId = $siteUrl.'/'.config('schema.ids.article', '#Article');
        $this->authorId = $siteUrl.'/'.config('schema.ids.author', '#Author');
        $this->blogPostId = $siteUrl.'/'.config('schema.ids.blog_post', '#BlogPosting');
        $this->contactPointId = $siteUrl.'/'.config('schema.ids.contact_point', '#ContactPoint');
        $this->founderId = $siteUrl.'/'.config('schema.ids.founder', '#Founder');
        $this->geoCoordinatesId = $siteUrl.'/'.config('schema.ids.geo_coordinates', '#GeoCoordinates');
        $this->localBusinessId = $siteUrl.'/'.config('schema.ids.local_business', '#LocalBusiness');
        $this->organizationId = $siteUrl.'/'.config('schema.ids.organization', '#Organization');
        $this->placeId = $siteUrl.'/'.config('schema.ids.place', '#Place');
        $this->postalAddressId = $siteUrl.'/'.config('schema.ids.postal_address', '#PostalAddress');
        $this->webPageId = $siteUrl.'/'.config('schema.ids.web_page', '#WebPage');
        $this->webPageElementId = $siteUrl.'/'.config('schema.ids.web_page_element', '#WebPageElement');
        $this->webSiteId = $siteUrl.'/'.config('schema.ids.web_site', '#WebSite');

        return $this;
    }
}
