<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesSocialLinks
{
    /** @throws BindingResolutionException */
    public function getSocialLinks(): array
    {
        $socialLinks = [];

        if (! empty(setting('client::social.facebook'))) {
            $socialLinks[] = setting('client::social.facebook');
        }
        if (! empty(setting('client::social.twitter'))) {
            $socialLinks[] = setting('client::social.twitter');
        }
        if (! empty(setting('client::social.linkedin'))) {
            $socialLinks[] = setting('client::social.linkedin');
        }
        if (! empty(setting('client::social.instagram'))) {
            $socialLinks[] = setting('client::social.instagram');
        }
        if (! empty(setting('client::social.youtube'))) {
            $socialLinks[] = setting('client::social.youtube');
        }
        if (! empty(setting('client::social.pinterest'))) {
            $socialLinks[] = setting('client::social.pinterest');
        }

        return $socialLinks;
    }
}
