<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Address;

use Bongo\Framework\Helpers\Str;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasLongitude
{
    public function initializeHasLongitude(): void
    {
        $this->mergeFillable(['longitude']);
    }

    public function hasLongitude(): bool
    {
        return ! empty($this->longitude);
    }

    protected function longitude(): Attribute
    {
        return Attribute::make(
            set: fn ($input) => $input ? Str::plainFloat($input) : null,
        );
    }
}
