<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

use Bongo\User\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;

trait HasDeletedBy
{
    public function initializeHasDeletedBy(): void
    {
        $this->mergeFillable(['deleted_by']);
    }

    public static function bootHasDeletedBy(): void
    {
        static::deleting(function ($model) {
            if (Schema::hasColumn($model->getTable(), 'deleted_by')) {
                $model->deleted_by = Auth::user() ? Auth::user()->id : null;
            }
        });
    }

    public function deleter(): BelongsTo
    {
        return $this->belongsTo(User::class, 'deleted_by')->withTrashed();
    }

    public function scopeByDeleter(Builder $query, ?int $userId = null): Builder
    {
        return $query->where('deleted_by', $userId ?? Auth::user()->id);
    }
}
