<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\PlainWords;

trait HasFirstName
{
    public function initializeHasFirstName(): void
    {
        $this->mergeFillable(['first_name']);
        $this->mergeCasts(['first_name' => PlainWords::class]);
    }

    public function hasFirstName(): bool
    {
        return ! empty($this->first_name);
    }
}
