<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\PlainWords;

trait HasLastName
{
    public function initializeHasLastName(): void
    {
        $this->mergeFillable(['last_name']);
        $this->mergeCasts(['last_name' => PlainWords::class]);
    }

    public function hasLastName(): bool
    {
        return ! empty($this->last_name);
    }
}
