<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Str;

trait HasKey
{
    public function initializeHasKey()
    {
        $this->mergeFillable(['key']);
    }

    public static function bootHasKey()
    {
        static::saving(function ($model) {
            if (empty($model->key)) {
                $model->key = $model->formatKey($model->name);
            }

            return $model;
        });
    }

    public function formatKey($input)
    {
        $input = str_replace('/', '_', $input);
        $input = Str::slug($input, '_');
        $input = trim($input);
        $input = strtolower($input);

        return $input;
    }
}
