<?php

namespace Bongo\Framework\Traits;

trait HasStatus
{
    public function initializeHasStatus(): void
    {
        $this->mergeFillable(['status']);
    }

    public function scopePending($query)
    {
        return $query->where('status', self::PENDING);
    }

    public function scopeActive($query)
    {
        return $query->where('status', self::ACTIVE);
    }

    public function scopeInactive($query)
    {
        return $query->where('status', self::INACTIVE);
    }

    public function isPending(): bool
    {
        return $this->status === self::PENDING;
    }

    public function isActive(): bool
    {
        return $this->status === self::ACTIVE;
    }

    public function isInactive(): bool
    {
        return $this->status === self::INACTIVE;
    }
}
