@if ($paginator->hasPages())

    <ul class="pagination mb-0 justify-content-end">

        {{-- Previous page --}}
        @if ($paginator->onFirstPage())
            <li class="page-item disabled" aria-disabled="true" aria-label="@lang('pagination.previous')">
                <a class="page-link" disabled="true" href="#">
                    <span class="d-lg-none">@lang('pagination.previous')</span>
                    <i class="d-none d-lg-inline-block fas fa-angle-left"></i>
                </a>
            </li>
        @else
            <li class="page-item">
                <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev"
                   aria-label="@lang('pagination.previous')"
                >
                    <span class="d-lg-none">@lang('pagination.previous')</span>
                    <i class="d-none d-lg-inline-block fas fa-angle-left"></i>
                </a>
            </li>
        @endif

        {{-- Individual Pages --}}
        @foreach ($elements as $element)

            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <li class="d-none d-lg-block page-item disabled" aria-disabled="true">
                    <span class="page-link">{{ $element }}</span>
                </li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li class="d-none d-lg-block page-item active">
                            <a class="page-link" disabled="true" href="#">{{ $page }}</a>
                        </li>
                    @else
                        <li class="d-none d-lg-block page-item">
                            <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                        </li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page --}}
        @if ($paginator->hasMorePages())
            <li class="page-item">
                <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next"
                   aria-label="@lang('pagination.next')"
                >
                    <span class="d-lg-none">@lang('pagination.next')</span>
                    <i class="d-none d-lg-inline-block fas fa-angle-right"></i>
                </a>
            </li>
        @else
            <li class="page-item disabled" aria-disabled="true" aria-label="@lang('pagination.next')">
                <a class="page-link" disabled="true" href="#">
                    <i class="d-none d-lg-inline-block fas fa-angle-right"></i>
                    <span class="d-lg-none">@lang('pagination.next')</span>
                </a>
            </li>
        @endif
    </ul>
@endif
