<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Bongo\Framework\Helpers\Str;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Database\Eloquent\Model;

class PlainLowerText implements CastsAttributes
{
    public function get(Model $model, string $key, mixed $value, array $attributes): ?string
    {
        return $value
            ? Str::plainLowerText($value)
            : $value;
    }

    public function set(Model $model, string $key, mixed $value, array $attributes): ?string
    {
        return $value
            ? Str::plainLowerText($value)
            : $value;
    }
}
