<?php

namespace Bongo\Framework\Helpers;

use Bongo\Framework\Schema\MetaSchema;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Database\Eloquent\Model;

class SEO
{
    /** @throws BindingResolutionException */
    public static function getMetaSchemaForPage(Model $entity): string
    {
        return (new MetaSchema())->graphForPage($entity);
    }

    /** @throws BindingResolutionException */
    public static function getMetaSchemaForPost(Model $entity): string
    {
        return (new MetaSchema())->graphForPost($entity);
    }

    /** @throws BindingResolutionException */
    public static function getMetaSchemaForProject(Model $entity): string
    {
        return (new MetaSchema())->graphForProject($entity);
    }
}
