<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesAuthor
{
    /** @throws BindingResolutionException */
    public function addAuthor(): self
    {
        $this->person($this->authorId)
            ->identifier($this->authorId)
            ->name($this->getAuthorName())
            ->email($this->getAuthorEmail())
            ->telephone($this->getAuthorPhone())
            ->url($this->getAuthorUrl());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getAuthorName(): ?string
    {
        return $this->entity->creator?->name ?? setting('client::company.name');
    }

    /** @throws BindingResolutionException */
    protected function getAuthorEmail(): mixed
    {
        return setting('client::company.email') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getAuthorPhone(): mixed
    {
        return setting('client::company.phone') ?? '--';
    }

    protected function getAuthorUrl(): string
    {
        return url()->to('/');
    }
}
